/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.client;

import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.montoyo.mcef.MCEF;
import net.montoyo.mcef.utilities.Log;

public class ShutdownThread
extends Thread {
    private Field running = null;
    private Minecraft mc = Minecraft.func_71410_x();

    public ShutdownThread() {
        super("MCEF-Shutdown");
        this.setDaemon(false);
        try {
            Field[] fields;
            for (Field f : fields = Minecraft.class.getDeclaredFields()) {
                if (!f.getType().equals(Boolean.TYPE) || f.getModifiers() != 64) continue;
                f.setAccessible(true);
                this.running = f;
                Log.info("volatile boolean Minecraft.running => %s", f.getName());
                break;
            }
        }
        catch (Throwable t) {
            Log.warning("Can't detect Minecraft shutdown:", new Object[0]);
            t.printStackTrace();
        }
    }

    @Override
    public void run() {
        if (this.running == null) {
            return;
        }
        Log.info("Minecraft shutdown detection thread started.", new Object[0]);
        while (true) {
            try {
                if (!this.running.getBoolean(this.mc)) {
                    break;
                }
            }
            catch (Throwable t) {
                Log.warning("Can't detect Minecraft shutdown:", new Object[0]);
                t.printStackTrace();
                return;
            }
            try {
                ShutdownThread.sleep(100L);
            }
            catch (Throwable throwable) {}
        }
        MCEF.PROXY.onShutdown();
    }
}

